﻿' Classes for testing all kinds of CPUs must implement this
' interface.
Public Interface ICpu
    ' The type of architecture that this object is for
    ReadOnly Property Type() As String

    '...
End Interface

' Classes for testing all kinds of memory management units must
' implement this interface.
Public Interface IMmu
    ' The type of architecture that this object is for
    ReadOnly Property Type() As String

    '...
End Interface

' Class for testing the CPU of a machine that uses the Ember 
' architecture.
Public Class EmberCpu
    Implements ICpu

    Public ReadOnly Property Type() As String _
        Implements ICpu.Type
        Get
            Return "Ember"
        End Get
    End Property

    '...
End Class

' Class for testing the MMU of a machine that uses the Ember 
' architecture.
Public Class EmberMmu
    Implements IMmu

    Public ReadOnly Property Type() As String _
        Implements IMmu.Type
        Get
            Return "Ember"
        End Get

        ' ...
    End Property
End Class

' Class for testing computers that use the Ember architecture.
Public Class EmberToolkit
    Implements IArchitectureToolkit

    ' Return an object for testing the CPU of a computer that
    ' uses the Ember architecure
    Public Function CreateCpu() As ICpu _
        Implements IArchitectureToolkit.CreateCpu
        Return New EmberCpu()
    End Function

    ' Return an object for testing the CPU of a computer that
    ' uses the Ember architecure
    Public Function CreateMmu() As IMmu _
        Implements IArchitectureToolkit.CreateMmu
        Return New EmberMmu()
    End Function
    '...
End Class

' Class for testing computers that use the Enginola
' architecture.
Public Class EnginolaCpu
    Implements ICpu

    Public ReadOnly Property Type() As String _
        Implements ICpu.Type
        Get
            Return "Enginola"
        End Get
    End Property
End Class

' Class for testing the MMU of a machine that uses the Enginola 
' architecture.
Public Class EnginolaMmu
    Implements IMmu

    Public ReadOnly Property Type() As String _
        Implements IMmu.Type
        Get
            Return "Enginola"
        End Get
    End Property

    ' ...
End Class

' Class for testing computers that use the Enginola
' architecture.
Public Class EnginolaToolkit
    Implements IArchitectureToolkit

    ' Return an object for testing the CPU of a computer that
    ' uses the Enginola architecure
    Public Function CreateCpu() As ICpu _
        Implements IArchitectureToolkit.CreateCpu
        Return New EnginolaCpu()
    End Function

    ' Return an object for testing the MMU of a computer that
    ' uses the Enginola architecure
    Public Function CreateMmu() As IMmu _
        Implements IArchitectureToolkit.CreateMmu
        Return New EnginolaMmu()
    End Function

    '...
End Class

' Abstract toolkit classes that create objects for testing 
' different components of the same architecture implmeent this
' interface.
Public Interface IArchitectureToolkit
    Function CreateCpu() As ICpu
    Function CreateMmu() As IMmu
    ' ...
End Interface

' This class is responsible for crating an instance of a class
' that implements the IArchitectureToolkit interface for a 
' specified architecture.
'
' This class is a singleton.
Public Class ToolkitFactory
    ' The single instance of this class.
    Private Shared myInstance As New ToolkitFactory()

    ' Symbolic names to identify computer architectures
    Public Enum ComputerArchitecture
        ENGINOLA = 900
        EMBER = 901
    End Enum

    ' Return this class's single instance.
    Public Shared ReadOnly Property Instance() As ToolkitFactory
        Get
            Return myInstance
        End Get
    End Property

    '
    ' Return a newly created object that implements the
    ' ArchitectureToolkitIF interface for the given computer
    ' architecture.
    '
    Public Function CreateToolkit(ByVal architecture As ComputerArchitecture) _
        As IArchitectureToolkit
        Select Case architecture
            Case ComputerArchitecture.ENGINOLA
                Return New EnginolaToolkit()

            Case ComputerArchitecture.EMBER
                Return New EmberToolkit()
        End Select
        Throw New System.ArgumentException("ArchId=" & architecture.ToString)
    End Function
End Class

' Very simple client class
Public Class Client
    Public Shared Sub Main()
        Dim myFactory As ToolkitFactory
        myFactory = ToolkitFactory.Instance
        Dim af As IArchitectureToolkit
        af = myFactory.CreateToolkit(ToolkitFactory.ComputerArchitecture.EMBER)
        Dim cpu As ICpu = af.CreateCpu()
        System.Console.WriteLine("Created Toolkit for cpu " & cpu.Type)
    End Sub
End Class
